/**
* \file: FeatureDiscovery.cpp
*
* \version: 0.1
*
* \release: $Name:$
*
* Implementation to send the create and send the vendor request
* via the respective transport layer to the mobile device.
*
* \component: Unified SPI
*
* \author: D. Girnus / ADIT/SW2 / dgirnus@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <inttypes.h>

#include <sys/socket.h>
#include <sys/types.h>

#include "FeatureDiscoveryImpl.h"
#include "FeatureDiscovery.h"


#ifndef DLT_UFD
#define DLT_UFD "UFD"
#endif

LOG_DECLARE_CONTEXT(uspi_fd)


namespace adit { namespace uspi {


FeatureDiscovery::FeatureDiscovery(IFeatureDiscoveryCb* inCallbacks, uint32_t inEventMask)
{
    /* register DLT context */
    LOG_REGISTER_CONTEXT(uspi_fd, DLT_UFD, "USPI Feature Discovery");

    /* create FeatureDiscovery implementation */
    mImpl = std::move(std::unique_ptr<FeatureDiscoveryImpl> (new FeatureDiscoveryImpl(this, inCallbacks, inEventMask)) );
}

FeatureDiscovery::~FeatureDiscovery()
{
    /* Release and delete the owned FeatureDiscoveryImpl */
    mImpl.reset(nullptr);

    /* unregister context from DLT */
    LOG_UNREGISTER_CONTEXT(uspi_fd);
}

DiscoveryError FeatureDiscovery::start()
{
    return mImpl->start();
}

DiscoveryError FeatureDiscovery::stop()
{
    return mImpl->stop();
}


} } /* namespace adit { namespace uspi { */

